import {Request, RequestHandler, Response} from "express";
import {Sandbox} from "../../../../remote/sandbox";
import {SandboxTaskStatusNotReady, SandboxTaskType} from "../../../../remote/sandbox/types";
import {GithubActionType, GithubPayload} from "./types";

export class GithubHandler {
    public ping: RequestHandler = (req: Request, res: Response) => {
        res.send('pong');
    };

    public githubPost: RequestHandler = async (req:Request, res: Response) => {
        const payload = req.body as GithubPayload;
        const type = this.getTypeFromPayload(payload);
        switch (type) {
            case GithubActionType.PUSH:
                await this.onPushHandler(payload, res);
                break;
        }
        if (res.writable) {
            res.send('done');
        }
    };

    private getTypeFromPayload(payload: GithubPayload): GithubActionType {
        if (payload.pusher) {
            return GithubActionType.PUSH;
        }
        return GithubActionType.UNDEFINED;
    }

    private async onPushHandler(payload: GithubPayload, res: Response) {
        const refInfo = (payload.ref || '').split('/');
        if (refInfo.length != 3) {
            return;
        }

        const tasks = await Sandbox.instance.getTasks({
            status: SandboxTaskStatusNotReady,
            descriptionRe: `.*${refInfo[2]}</a>.*`,
            type: [SandboxTaskType.TRENDBOX_CI_JOB_BETA],
        });
        let ids: number[] = [];
        for (let i = 0; i < tasks.items.length; i++) {
            if (tasks.items[i].description.indexOf(payload.head_commit.id) < 0) {
                ids.push(tasks.items[i].id);
            }
        }
        await Sandbox.instance.stopTasksByIds(ids);
    };
}
