import {RequestHandler} from 'express';

import {ServiceHandler, HttpMethod} from '../../types';

const hello: RequestHandler = (req, res) => {
    res.send('Hello there!');
};

const general: RequestHandler = (req, res) => {
    res.send('General Kenobi!');
};

const generalPost: RequestHandler = (req, res) => {
    const body = req.body;
    const name = (typeof body === 'object' && body.name) || 'Anonymous';

    res.json({
        message: `General Kenobi! —— ${name}`,
    });
};

export const serviceHandlers: ServiceHandler[] = [
    {
        path: '/',
        method: HttpMethod.GET,
        handler: hello,
    },
    {
        path: '/kenobi',
        method: HttpMethod.GET,
        handler: general,
    },
    {
        path: '/kenobi',
        method: HttpMethod.POST,
        handler: generalPost,
    },
];
