import {Request, RequestHandler, Response} from "express";
import {ClickhouseClient, ClickhouseClientType} from "../../../../remote/clickhouse";
import config from '../../../../remote/clickhouse/config.json';
import {IData} from "../../../../remote/clickhouse/types";

export class LoggerHandler {
    private clickhouse: ClickhouseClientType;

    constructor() {
        this.clickhouse = new ClickhouseClient();
    }

    public upload: RequestHandler = async (req: Request, res: Response) => {
        const inititator = req.params.type;
        const timestamp = Math.floor(Date.now() / 1000);

        process.stderr.write(JSON.stringify(req.body)+ '\n');

        const logs: IData = {
            env: 'infra',
            initiator: inititator,
            timestamp: timestamp,
            date: timestamp,
            data: Array.isArray(req.body) ? req.body : [req.body],
        };

        if (inititator === 'test') {
            logs.test = true;
        }

        const responseFromClickhouse = await this.clickhouse.insertLogs(logs);
        res.send(`Clickhouse response with: ${responseFromClickhouse}\nCheck https://deploy.yandex-team.ru/stages/krush/logs for more info\n`);
    }

    public welcome: RequestHandler = (req: Request, res: Response) => {
        const {base, table} = config;
        res.send(`<h2>Welcome</h2><h3>Current DB: ${base}</h3><h3>Current table: ${table}</h3>`);
    }
}
