export interface TimelineRequestBody {
    ticketId: string;
    filterTags: string[];
    // поле - обход ошибок TS
    isError: false;
}

export interface RawTimelineRequestBody {
    ticketId: string;
    filterTags: string;
}

export interface TimelineErrorFields {
    ticketId?: string;
    general?: string;
}

export interface TimelineError {
    error: TimelineErrorFields;
    // поле - обход ошибок TS
    isError: true;
}

export interface TaskGroup {
    id: number;
    treeLevel: number;
    content: string;
}

export interface TaskGroupWithNest extends TaskGroup {
    nestedGroups: number[];
}

export interface TaskGroups {
    groups: TaskGroup[];
    groupsWithNest: TaskGroupWithNest[];
}

export const enum TaskItemType {
    box = 'box',
    point = 'point',
    range = 'range',
    background = 'background',
}

export interface TaskItem {
    id: number;
    group: number;
    content: string;
    start: string;
    end: string;
    title: string;
    type: TaskItemType;
    isClosed: boolean;
}

export interface TimelineData {
    tasksGroups: TaskGroups,
    tasksItems: TaskItem[]
}
