import {TicketNode} from '../../../../remote/startrek/types';
import {BudgetTeamDefinition} from '../../../../lib/budget/types';

export enum BudgetPreset {
    ppd = 'ppd',
    all = 'all',
}

export interface BudgetSettings {
    excludeFromBudgetTags: string[];
    teamFilterForBudget: string[];
    teamDefinitions: BudgetTeamDefinition[];
}

export interface WbsRequestBody {
    ticketId: string;
    filterTags: string[];
    outputTicketId?: string;
    budgetPreset?: BudgetPreset;
    // поле - обход ошибок TS
    isError: false;
}

export interface RawWbsRequestBody {
    ticketId: string;
    outputTicketId?: string;
    filterTags?: string;
    budgetPreset?: string;
}

export interface WbsErrorFields {
    ticketId?: string;
    outputTicketId?: string;
    filters?: string;
    preset?: string;
    details?: any;
    general?: string;
}

export interface WbsError {
    error: WbsErrorFields,
    // поле - обход ошибок TS
    isError: true,
}

export interface FilteredTickets {
    [key: string]: TicketNode[],
}


