import {RequestHandler} from 'express';

export type PathParams = string | RegExp | Array<string | RegExp>;

export enum HttpMethod {
    GET = 'GET',
    POST = 'POST',
    PUT = 'PUT',
    DELETE = 'DELETE',
}

export interface ServiceHandler {
    method: HttpMethod;
    path: PathParams;
    handler: RequestHandler;
}
