import superagent, {Response} from "superagent";
import {TvmManager} from "./TvmManager";

export class GoZoraClient {
    private static zoraUrl: string = 'http://go.zora.yandex.net:1080/'
    private static destHeader: string = 'x-ya-dest-ur';
    private static serviceHeader: string = 'x-ya-service-ticket';
    private static clientHeader: string = 'x-ya-client-id';

    private constructor() {
    }

    static async get(url: string): Promise<Response | undefined> {
        const ticket = await TvmManager.getTicket(TvmManager.zoraId);
        return await superagent('GET', GoZoraClient.zoraUrl)
            .set({
                'x-ya-dest-url': url,
                'x-ya-service-ticket': ticket,
            });
    }
}
