import {GoZoraClient} from "./GoZoraClient";

export interface ExtraReplyMessage {
    parse_mode?: 'Markdown' | 'MarkdownV2' | 'HTML'
    disable_web_page_preview?: boolean
    disable_notification?: boolean
    reply_to_message_id?: number
}

export class TelegramClient {
    private readonly TOKEN_TMPL = '{token}';
    private readonly token: string;
    private readonly telegramApi = `https://api.telegram.org/bot${this.TOKEN_TMPL}/sendMessage?`;

    constructor(token: string) {
        this.token = token;
        this.telegramApi = this.telegramApi.replace(this.TOKEN_TMPL, this.token);
    }

    public async sendMessage(chatId: number | string, text: string, extra?: ExtraReplyMessage): Promise<string|undefined> {
        const data: Record<'chat_id'| 'text' | string, string> = {};
        data.chat_id = chatId as string;
        data.text = text;
        if (extra) {
            for (const k in extra) {
                data[k] = (extra as any)[k] as string;
            }
        }
        const url = this.telegramApi + (new URLSearchParams(data).toString());
        const response = await GoZoraClient.get(url);
        return response?.body;
    }
}
