import superagent from "superagent";

interface TvmId {
    id: number,
    alias: string,
}

export class TvmManager {
    private static _selfId: TvmId = {
        id: 2036344,
        alias: 'krusher',
    };
    private static _zoraId: TvmId = {
        id: 2023123,
        alias: 'gozora',
    };

    private static tvmUrl: string = `http://localhost:2/v2/tickets?self=${TvmManager._selfId.alias}&dsts={dst}`
    private static token: string;

    static setToken(token: string): void {
        TvmManager.token = token;
    }

    public static get selfId() {
        return TvmManager._selfId;
    }

    public static get zoraId() {
        return TvmManager._zoraId;
    }

    static async getTicket(destination: TvmId): Promise<string> {
        const url = TvmManager.tvmUrl.replace('{dst}', destination.alias);
        try {
            const response = await superagent('GET', url)
                .set({'Authorization': this.token});
            return response.body[destination.alias]['ticket'];
        } catch (e) {
            console.log(e);
            return '';
        }
    }
}
