import {BudgetClass, BudgetTeamItem} from '../budget/types';

const formatBudgetNumber = (number: number): string => {
    let result: string;
    number = Math.round(number * 10) / 10;
    result = Math.round(number) === number ? number.toString() : number.toFixed(1);
    return result;
};

export const budgetToMarkdown = (budget: BudgetClass): string => {
    if (!budget.teams) {
        return '';
    }

    let result = '  #|\n  || **Команда** | **Потрачено SP** | **Оценено SP** | **Не оценено шт.** ||\n';

    let totalSpentSP = 0;
    let totalEstimatedSP = 0;
    let isSubjectForPrinting;

    const teamsArray: BudgetTeamItem[] = Object.values(budget.teams);

    teamsArray.forEach((team) => {
        isSubjectForPrinting =
            (budget.teamFilter.length == 0 || budget.teamFilter.includes(team.name)) &&
            (team.estimatedSP || team.spentSP || team.numEndTasksWithoutEstimation);

        if (isSubjectForPrinting) {
            result += `  || ${team.name}`;
            result += `  |  ${formatBudgetNumber(team.spentSP)}`;
            result += `  |  ${formatBudgetNumber(team.estimatedSP)} `;
            result += `  |  ${formatBudgetNumber(team.numEndTasksWithoutEstimation)} ||\n`;
            if (team.spentSP) totalSpentSP += team.spentSP;
            if (team.estimatedSP) totalEstimatedSP += team.estimatedSP;
        }
    });

    result += `  |#\n`;

    const budgetHeader = `\n=== Показатели бюджета \n`;
    const initialBudget = `  1. Изначальный бюджет в SP: ${formatBudgetNumber(budget.originalSP)}\n`;
    const spentBudget = `  1. Потрачено: ${formatBudgetNumber(totalSpentSP)} / Оценено: ${formatBudgetNumber(totalEstimatedSP)} \n`;

    return `${budgetHeader}${initialBudget}${spentBudget}${result}`;
};
