export function flattenObj(obj: Object, level: number, prefix: string = ''): Object {
    const res = {};
    rec(obj, res, level);
    return res;
}

/**
    Функция rec рекурсивно обходит значения объекта до заданной глубины, попутно добавляя свойства в объект res уровнем выше.
    Добавление свойства работает за O(1), а значит общее время выполнения кода равно O(n), где n - кол-во пар "ключ" - "значение".
    (Даже несколько меньше, тк с определенной глубины вложенности вложенные объекты просто превращаются в строку)
 **/

function rec(obj: any, res: any, level: number, prefix: string = '') {
	for (let key of Object.keys(obj)) {
        const prefixedKey = prefix !== '' ? `${prefix}_${key}` : key;
        const currValue = obj[key];
        if (currValue instanceof Object) {
            if (level > 0) {
                rec(currValue, res, level - 1, prefixedKey);
            } else {
                res[prefixedKey] = JSON.stringify(currValue);
            }
        } else {
            res[prefixedKey] = currValue;
        }
    }
}
