import {flattenObj} from '../../lib/helpers/index'
import {IData, ObjWithStringPairs} from "./types";

export class Schema {
    private base: string;
    private table: string

    constructor(base: string, table: string) {
        this.base = base;
        this.table = table;
    }
    // БД принимает в поле data пары строка-строка, для этого проводим преобразование
    private dataSanitize = (obj: ObjWithStringPairs) => {
        const res = flattenObj(obj, 2);
        const sanitizedStr = JSON.stringify(res, (key, value) => {
            if (
                typeof value === 'string'
            ) return value.replace(/(\\")|"|'|(\\')/g, '`');

            if (
                typeof value === 'number' ||
                typeof value === 'boolean' ||
                value === null
            ) return String(value);

            return value;
        });
        return sanitizedStr.replace(/"|(\\")|(\\')/g, '\'');
        }


    public insert = (logs: IData) => {
        const {env, initiator, date, timestamp, data = [], test} = logs;
        const values = data.map(value => {
            const sanitizedData = this.dataSanitize(value);
            return `(
                '${env}',
                '${initiator}',
                ${date},
                ${timestamp},
                generateUUIDv4(),
                ${sanitizedData})`
        })

        return `INSERT INTO ${this.base}.${test ? 'test' : this.table}
        VALUES ${values.join(' ')}`;
    }
}

export type SchemaType = ReturnType <() => Schema>;
