import {HttpMethod} from '../../interface/webhooks/types';


export type ObjWithStringPairs = {[key: string]: string};

export type Data = ObjWithStringPairs[];

export interface IRequestData {
    method: HttpMethod;
    host?: string;
    query: string;
};

export interface IData {
    env: string;
    initiator: string;
    timestamp: number;
    date: number;
    data?: Data;
    test?: boolean;
}

export interface IConfig {
    hosts: string[];
    defaultHost: string;
    base: string;
    table: string;
    userName: string;
    userPassword?: string;
    port: string;
}
