export enum SandboxOwner {
    PARTNER_FRONT= 'PARTNER_FRONT',
    PARTNER = 'PARTNER',
    OTHER = 'OTHER',
}

export enum SandboxTaskPriorityClass {
    BACKGROUND = 'BACKGROUND',
    SERVICE = 'SERVICE',
    USER = 'USER',
}

export enum SandboxTaskPrioritySubClass {
    LOW = 'LOW',
    MEDIUM = 'MEDIUM',
    HIGH = 'HIGH',
}

export enum SandboxTaskStatus {
    NOT_READY = 'NOT_READY',
    ENQUEUED = 'ENQUEUED',
    ENQUEUING = 'ENQUEUING',
    EXECUTING = 'EXECUTING',
    FINISHED = 'FINISHED',
    STOPPING = 'STOPPING',
    STOPPED = 'STOPPED',
    FAILURE = 'FAILURE',
    WAIT_CHILD = 'WAIT_CHILD',
    WAIT_DEPS = 'WAIT_DEPS',
    WAIT_MUTEX = 'WAIT_MUTEX',
    UNKNOWN = 'UNKNOWN',
    DELETED = 'DELETED',
}

export const SandboxTaskStatusNotReady = [
    SandboxTaskStatus.NOT_READY,
    SandboxTaskStatus.ENQUEUED,
    SandboxTaskStatus.ENQUEUING,
    SandboxTaskStatus.EXECUTING,
    SandboxTaskStatus.WAIT_CHILD,
    SandboxTaskStatus.WAIT_DEPS,
    SandboxTaskStatus.WAIT_MUTEX,
    SandboxTaskStatus.UNKNOWN,
];

export enum SandboxTaskType {
    TRENDBOX_CI_JOB_BETA = 'TRENDBOX_CI_JOB_BETA',
    PARTNER_E2E_MAKE_UPDATE_REFS_PR = 'PARTNER_E2E_MAKE_UPDATE_REFS_PR'
}

export enum SandboxTaskAction {
    START = 'start',
    STOP = 'stop',
}

export interface SandboxTaskQuery {
    limit?: number,
    owner?: SandboxOwner,
    status?: SandboxTaskStatus[],
    type?: SandboxTaskType[],
    descriptionRe?: string,
}

export interface SandboxObjectInfo {
    id: number,
    description: string,
    status: SandboxTaskStatus,
}
export interface SandboxObjectList {
    items: [SandboxObjectInfo],
}
