import superagent from 'superagent';

const SENTRY_AUTH_KEY = 'Authorization';
const SENTRY_AUTH_PREFIX = 'Bearer';
const SENTRY_URL = 'https://sentry.t.yandex-team.ru/api/0/projects/partnerinterface/nodejs/';

export interface Project {
    options: {
        'filters:error_messages': string,
    },
}

let TOKEN = '';

export function setToken(token: string): void {
    TOKEN = token;
}

function getToken(): string {
    return TOKEN;
}

export async function getProject(): Promise<Project> {
    return superagent
        .get(SENTRY_URL)
        .set(SENTRY_AUTH_KEY, `${SENTRY_AUTH_PREFIX} ${getToken()}`)
        .then<Project>((res) => {
            return res.body;
        });
}

export async function setProject(nextProject: Partial<Project>): Promise<Project> {
    return superagent
        .put(SENTRY_URL)
        .set(SENTRY_AUTH_KEY, `${SENTRY_AUTH_PREFIX} ${getToken()}`)
        .send(nextProject)
        .then<Project>((res) => {
            return res.body;
        });
}

export async function getIgnoreRules(): Promise<string> {
    const project = await getProject();

    const rules = project.options['filters:error_messages'];
    return rules;
}

export async function setIgnoreRules(newRules: string): Promise<string> {
    const nextProject: Project = {
        options: {
            'filters:error_messages': newRules,
        },
    };

    const project = await setProject(nextProject);

    const rules = project.options['filters:error_messages'];
    return rules;
}
