import superagent from 'superagent';

const SLACK_REQUEST_CONTENT_TYPE = 'Content-Type';
const SLACK_REQUEST_CONTENT_TYPE_VALUE = 'application/json';

let TOKEN = '';

export function setSlackUrl(token: string): void {
    TOKEN = token;
}

function getSlackUrl(): string {
    return TOKEN;
}

function parseErrorResponse(body: any): string {
    const errorMessage = body?.response?.error?.text;

    if (typeof errorMessage !== 'string') {
        return 'Error message is not a string';
    }

    return errorMessage;
}

export async function addCommentToReleaseChannel(message: string): Promise<any> {
    const url = getSlackUrl();
    return superagent
        .post(url)
        .set(SLACK_REQUEST_CONTENT_TYPE, SLACK_REQUEST_CONTENT_TYPE_VALUE)
        .send({
            text: message,
        })
        .catch((agentError) => {
            if (agentError?.response) {
                const errorMessage = parseErrorResponse(agentError);
                throw new Error(errorMessage);
            }

            throw new Error(String(agentError))
        });
}
