import {Moment} from 'moment';

export interface StartrekProperty {
    self: string,
    id: string,
    key: string,
    display: string,
}

export enum TicketLinkType {
    Subtask = 'subtask',
    Relates = 'relates',
}

// запрос на связанные тикеты, возвращает не только подзадачи исходного тикета, но и задачи, подзадачей которых он является
// у связанных тикетов приходит поле direction, которое может принимать значения:
// inward - исходный тикет в запросе /issues/${ticketId}/links является подазадачей по отношению к связанной задаче (link)
// outward - исходный тикет в запросе /issues/${ticketId}/links является родительским по отношению к связанной задаче (link)
export enum TicketLinkDirection {
    Inward = 'inward',
    Outward = 'outward',
}

export interface TicketLink {
    object: StartrekProperty,
    type: {
        id: TicketLinkType,
    }
    direction: TicketLinkDirection,
}

export interface Ticket {
    id: string;
    self: string;
    summary: string;
    createdBy: StartrekProperty;
    assignee: StartrekProperty;
    status: StartrekProperty;
    storyPoints: number;
    originalStoryPoints: number;
    tags: string[];
    start: string;
    end: string;
    sprint: StartrekProperty;
    currentStatusStartTime: string;
    isFinished: boolean;
    isError: false;
}

export interface TicketNode extends Ticket {
    parentId: string | null;
    nest: number;
}

export interface Sprint {
    id: string;
    startDate: Moment;
    endDate: Moment;
}

export function isTicketNode(node: any): node is TicketNode {
    return node && !node.isError;
}

