import {TelegramClient} from "../../lib/TelegramClient";

export const enum Chats {
    'release_pi'= 'release_pi',
    'front_emergency'= 'front_emergency',
    'forx'= 'forx',
    's-shirshov'= 's-shirshov',
    'pavelpilyak'= 'pavelpilyak',
    'tessitore'= 'tessitore',
    'npechenov'= 'npechenov',
    'nefri'= 'nefri',
}

const ChatsIds = {
    [Chats.release_pi]: -1001412282433,
    [Chats.front_emergency]: -378824775,
    [Chats.forx]: 114363944,
    [Chats["s-shirshov"]]: 352327714,
    [Chats.pavelpilyak]: 246173275,
    [Chats.tessitore]: 148067727,
    [Chats.npechenov]: 34766416,
    [Chats.nefri]: 165432384,
};

let TOKEN = '';

export function setToken(token: string): void {
    TOKEN = token;
}

function getToken(): string {
    return TOKEN;
}

function getChatIdsToNotify(key: Chats) {
    // TODO: добавить получение из тикета chat_id с текущим ответственным за релиз
    if (!ChatsIds[key]) {
        return [];
    }
    return [ChatsIds[key]];
}

function parseErrorResponse(body: any): string {
    const errorMessage = body?.response?.description;

    if (typeof errorMessage !== 'string') {
        return 'Error message is not a string';
    }

    return errorMessage;
}

export async function addCommentToReleaseChat(message: string, chat: Chats, disableNotifications?: boolean): Promise<any> {
    const client = new TelegramClient(getToken());

    const chatIds: number[] = getChatIdsToNotify(chat);

    return Promise.all(
        chatIds.map((chatId: number) => {
            return client.sendMessage(
                    chatId,
                    message,
                    {disable_notification: disableNotifications, parse_mode: 'Markdown'}
                ).catch((agentError) => {
                    if (agentError?.response) {
                        const errorMessage = parseErrorResponse(agentError);
                        throw new Error(errorMessage);
                    }

                    throw new Error(String(agentError))
                });
        })
    );
}
