import * as React from 'react';
import {Route, Switch, withRouter, useLocation} from 'react-router-dom';

import {Wbs} from './wbs';
import {TimelineForm} from './timeline';
import {PageSwitcher} from './components/PageSwitcher';

const AppComponent = () => {
    const basePath = BASE_PATH || '';

    const {pathname} = useLocation();

    return (
        <>
            <PageSwitcher switchValue={pathname}/>
            <Switch>
                <Route path={`${basePath}/wbs/form`} component={Wbs} />
                <Route path={`${basePath}/timeline/form`} component={TimelineForm} />
            </Switch>
        </>
    )
};

export const App = withRouter(AppComponent);
