import * as React from 'react';

import {Button} from '@yandex-lego/components/__internal__/src/components/Button/Button.bundle/desktop';

import styles from './styles.css';

interface FormProps {
    headline: string;
    onButtonClickHandler: VoidFunction;
    buttonText: string;
}

export class Form extends React.PureComponent<FormProps> {
    render(): React.ReactElement {
        const {children, headline, buttonText, onButtonClickHandler} = this.props;

        return (
            <div className={styles.form}>
                <span className={styles.headline}>{headline}</span>
                <div className={styles.formGroupsWrapper}>
                    {children}
                </div>
                <Button
                    view="action"
                    size="m"
                    theme="action"
                    type="submit"
                    className={styles.button}
                    onClick={onButtonClickHandler}
                >
                    {buttonText}
                </Button>
            </div>
        )
    }
}
