import * as React from 'react';

import {compose} from '@bem-react/core'
import {Textinput, withViewDefault, withSizeM} from '@yandex-lego/components/Textinput/desktop'

import styles from './styles.css';

const TextInput = compose(withViewDefault, withSizeM)(Textinput);

interface FormGroupProps {
    label: string;
    required?: boolean;
    children: React.ReactNode;
}

interface FormInputGroupProps {
    label: string;
    placeholder: string;
    hint: string;
    value: string;
    onChange: (value: string) => void;
    state?: 'error';
    required?: boolean;
    disabled?: boolean;
}

export const FormGroup = (props: FormGroupProps) => {
    const {label, required = false, children} = props;

    return (
        <div className={styles.formGroup}>
            <span className={styles.label}>
                {label}
                {required && <span className={styles.required}>*</span>}
            </span>
            {children}
        </div>
    );
};

export const FormInputGroup = (props: FormInputGroupProps) => {
    const {label, placeholder, hint, value, state, onChange, required, disabled = false} = props;

    const onChangeHandler = (event: React.SyntheticEvent<HTMLInputElement>): void => {
        const {value} = event.currentTarget;
        onChange(value);
    };

    return (
        <FormGroup
            label={label}
            required={required}
        >
            <TextInput
                size="m"
                view="default"
                value={value}
                placeholder={placeholder}
                hint={hint}
                state={state}
                onChange={onChangeHandler}
                disabled={disabled}
            />
        </FormGroup>
    );
};
