import * as React from 'react';
import qs from 'qs';
import {useHistory, useLocation} from 'react-router-dom';
import {History, Search} from 'history';

import {RadioButton} from "@yandex-lego/components/__internal__/src/components/RadioButton/RadioButton.bundle/desktop";

import styles from './styles.css';

const basePath = BASE_PATH || '';

export const Page =  {
    wbs: `${basePath}/wbs/form`,
    timeline: `${basePath}/timeline/form`,
};

interface PageSwitcherProps {
    switchValue: string;
}

const onPageSwitchHandler = (event: React.SyntheticEvent<HTMLInputElement>, history: History, search: Search) => {
    const {value} = event.currentTarget;

    const query = new URLSearchParams(search);
    const ticket = query.get('ticket');
    const queryParams = ticket ? qs.stringify({ticket}, { addQueryPrefix: true }) : '';

    history.push(`${value}${queryParams}`);
};

export const PageSwitcher = ({switchValue}: PageSwitcherProps) => {
    let history = useHistory();
    const {search} = useLocation();

    return (
        <div className={styles.switchWrapper}>
            <div className={styles.switch}>
                <RadioButton
                    size="m"
                    view="default"
                    value={switchValue}
                    options={[
                        { value: Page.wbs, children: 'ИСР'},
                        { value: Page.timeline, children: 'График' },
                    ]}
                    onChange={(event) => onPageSwitchHandler(event, history, search)}
                />
            </div>
        </div>
    )
};
