import * as React from 'react';
import {DataSet, Timeline as VisTimeline} from 'vis-timeline/standalone';
import {TaskGroups, TaskItem} from '../../../interface/webhooks/service/timeline/types';
import styles from './styles.css';

interface TimelineProps {
    groups: TaskGroups;
    items: TaskItem[];
}

export class Timeline extends React.Component<TimelineProps> {
    componentDidMount() {
        const {groups, items} = this.props;
        return initTimeline(groups, items);
    }

    render() {
        return (
            <div id="timeline"></div>
        );
    }
}

function initTimeline(taskGroups: TaskGroups, taskItems: TaskItem[]) {
    const container = document.getElementById("timeline");

    const visGroups = {
        groups: taskGroups.groupsWithNest,
        groups3: taskGroups.groups,
    };

    // create a data set with groups
    const finalGroups = new DataSet();
    finalGroups.add(visGroups.groups);
    finalGroups.add(visGroups.groups3);

    const itemsWithClassname = taskItems.map((item) => {
        return {
            ...item,
            className: item.isClosed ? styles.done : ''
        }
    });

    // create a dataset with items
    const finalItems = new DataSet(itemsWithClassname);

    // @ts-ignore
    window.timeline = new VisTimeline(container, finalItems, finalGroups);
}
