const path = require('path');
const HtmlWebpackPlugin = require('html-webpack-plugin');
const MiniCssExtractPlugin = require('mini-css-extract-plugin');

const config = {
    entry: ['./src/ui/index.tsx'],
    output: {
        path: path.join(__dirname, 'build/'),
        filename: 'index.js',
    },
    module: {
        rules: [
            {
                test: /\.tsx$|\.ts$/,
                exclude: /node_modules/,
                use: 'ts-loader'
            },
            {
                test: /\.css$/,
                oneOf: [{
                    test: /node_modules\//,
                    use: [
                        MiniCssExtractPlugin.loader,
                        {
                            loader: 'css-loader',
                            options: {
                                modules: false,
                            }
                        },
                    ]
                }, {
                    use: [
                        MiniCssExtractPlugin.loader,
                        {
                            loader: 'css-loader',
                            options: {
                                modules: true,
                            }
                        },
                    ]
                }]
            },
            {
                test: /node_modules\/frappe-gantt\/src\/gantt.scss$/,
                use: [
                    MiniCssExtractPlugin.loader,
                    {
                        loader: 'css-loader',
                        options: {
                            modules: false,
                        }
                    },
                    {
                        loader: 'sass-loader',
                    },
                ],
            },
            {
                test: /\.svg$/,
                loader: 'svg-inline-loader'
            },
        ]
    },
    resolve: {
        extensions: [ '.tsx', '.ts', '.js', '.css'],
    },
    plugins: [
        new HtmlWebpackPlugin({
            title: 'Neokrush - Webhooks',
            templateContent: ({htmlWebpackPlugin}) => `
                <html>
                    <head>
                        <meta charset="utf-8">
                        <meta name="viewport" content="width=device-width,initial-scale=1">
                        <title>${htmlWebpackPlugin.options.title}</title>
                    </head>
                    <body>
                        <div id="app"></div>
                    </body>
                </html>
            `
        }),
        new MiniCssExtractPlugin(),
    ]
};

module.exports = config;
