import React from 'react';
import {BrowserRouter as Router, Switch, Route, Redirect, NavLink, Link} from 'react-router-dom';
import {configureRootTheme} from '@yandex-lego/components/Theme';
import {theme} from '@yandex-lego/components/Theme/presets/default';
import queryString from 'query-string';

import {
    saveConverter,
    setBoard, setChildren,
    setIssues,
    setSprints, setStoryPoints,
} from './components/QuarterConfigurator/QuarterConfigurator.middlewares';
import {QuarterConfigurator} from './components/QuarterConfigurator/QuarterConfigurator';
import {Configurator} from './components/SprintPlanner/Configurator';
import {Analyzer} from './components/Analyzer/Analyzer';
import {BoardList} from './components/BoardList/BoardList';
import {TaskStoreProvider} from './components/TaskStoreProvider/TaskStoreProvider';
import Tree from './components/Tree/Tree';
import QuarterList from './components/QuoterList/QuarterList';

import './App.css';


configureRootTheme({theme});

const BASE_URL = window.location.host === 'pages.github.yandex-team.ru' ? '/traden/planner' : '';

const parsedSearch = queryString.parse(window.location.search);
const parsedPath = window.location.pathname;

export default class App extends React.Component {
    constructor(props) {
        super(props);
        this.state = {autoRefresh: false};
    }

    componentDidMount() {
        const scrollBar = document.getElementById('scrollBar');
        const mainDiv = document.getElementById('main');
        mainDiv &&
        mainDiv.addEventListener('scroll', () => {
            if (scrollBar)
                scrollBar.style.background =
                    mainDiv.scrollTop > 3 ? 'linear-gradient(to top, transparent, lightgray)' : 'transparent';
        });
    }

    render() {
        return (
            <div id='wrapper'>
                <Router>
                    <div id='TopMenu'>
                        <div id='logoContainer'>
                            <Link to={`${BASE_URL}/`} id='logoLink'>
                                <img alt='planner' src='/planner_logo.svg' />
                                <div style={{width: 10}} />
                                Planner
                            </Link>

                            <nav>
                                <NavLink to={`${BASE_URL}/boards/`} activeClassName='ActiveNavLink'>
                                    Спринты
                                </NavLink>
                                &nbsp;
                                <NavLink to={`${BASE_URL}/tree/`} activeClassName='ActiveNavLink'>
                                    Дерево
                                </NavLink>
                                <NavLink to={`${BASE_URL}/quarters/`} activeClassName='ActiveNavLink'>
                                    Кварталы
                                </NavLink>
                                &nbsp;
                                {(parsedSearch.a === 'b' || parsedPath.indexOf('analyzer') > -1) && (
                                    <NavLink to={`${BASE_URL}/analyzer/`} activeClassName='ActiveNavLink'>
                                        Анализ
                                    </NavLink>
                                )}
                            </nav>
                        </div>
                    </div>
                    <div id='main'>
                        <div id='scrollBar'></div>
                        <Switch>
                            <Route
                                path={`${BASE_URL}/boards/:key`}
                                render={(props) => {
                                    return (
                                        <TaskStoreProvider taskKey={props.match.params.key}>
                                            {(config, setConfig) => {
                                                return (
                                                    <Configurator config={config} setConfig={setConfig} />
                                                );
                                            }}
                                        </TaskStoreProvider>
                                    );
                                }}
                            />
                            <Route
                                path={`${BASE_URL}/quarters/:key`}
                                render={(props) => {
                                    return (
                                        <TaskStoreProvider
                                            saveConverter={saveConverter}
                                            middlewares={[
                                                setBoard,
                                                setSprints,
                                                setIssues,
                                                setChildren,
                                                setStoryPoints,
                                            ]}
                                            taskKey={props.match.params.key}
                                        >
                                            {(config, setConfig, update, {saveInProgress, updating}) => (
                                                <QuarterConfigurator
                                                    config={config}
                                                    updateConfig={update}
                                                    setConfig={setConfig}
                                                    saveInProgress={saveInProgress}
                                                    updating={updating}
                                                />
                                            )}
                                        </TaskStoreProvider>
                                    );
                                }}
                            />
                            <Route path={`${BASE_URL}/quarters/`} component={QuarterList} />
                            <Route path={`${BASE_URL}/boards/`} component={BoardList} />
                            <Route path={`${BASE_URL}/tree/`} component={Tree} />
                            <Route path={`${BASE_URL}/analyzer/`} component={Analyzer} />
                            <Redirect path={`${BASE_URL}/`} to={`${BASE_URL}/boards`} />
                        </Switch>
                    </div>
                </Router>
            </div>
        );
    }
}
