import React, {useState, useEffect, useCallback} from 'react';
import {apiCall, apiEditTask, apiSearch} from "./startrek";


class TaskStoreProvider extends React.PureComponent {
    constructor(props) {
        super(props);
        this.state = {
            config: {},
            commentId: null,
            version: 0,
            updateLocked: false,
        }
    }

    updateConfigFromTask = async() => {
        if (this.state.updateLocked) {
            console.log('updateConfigFromTask: update locked');
            return;
        }
        const comments = await apiCall(`issues/${this.props.taskKey}/comments`);
        if (this.state.updateLocked) {
            console.log('updateConfigFromTask: update locked');
            return;
        }
        for (const comment of comments) {
            const matches = comment.text.match(/%%((?:.|\n)*)%%/);
            if (matches) {
                const config = JSON.parse(matches[1]);
                if (config && comment.version > this.state.version) {
                    console.log('new json config found');
                    this.setState({
                        config,
                        commentId: comment.id,
                        version: comment.version,
                    });
                    return;
                }
            }
        }
    }

    componentDidMount = () => {
        this.updateConfigFromTask();
        if (this.props.watch) {
            this.timer = setInterval(this.updateConfigFromTask, 1000);
        }
    }

    componentWillUnmount() {
        if (this.timer) {
            clearInterval(this.timer);
            this.timer = null;
        }
    }

    setConfig = async (configPart) => {
        if (this.state.updateLocked) {
            console.log('setConfig: update locked');
            return;
        }
        console.log('setConfig');
        const config = {...this.state.config, ...configPart};
        this.setState({
            config,
            updateLocked: true,
        });
        const jsonConfig = JSON.stringify(config, null, 4);
        const description = `Autogenerated by planner\n\n%%\n${jsonConfig}\n%%\n`;

        let comment;
        if (this.state.commentId) {
            const uri = `issues/${this.props.taskKey}/comments/${this.state.commentId}`;
            comment = await apiCall(uri, {text: description}, 'PATCH');
        } else {
            const uri = `issues/${this.props.taskKey}/comments`;
            comment = await apiCall(uri, {text: description}, 'POST');
        }
        console.log('new config task was saved');
        this.setState({
            config,
            version: comment.version,
            updateLocked: false,
        });
    }

    render() {
        return this.state.version ? this.props.children(this.state.config, this.setConfig) : null;
    }
}


export const Test = () => {
    const [show, setShow] = useState(false);
    return (
        <div>
            <button onClick={() => setShow(!show)}>toggle</button>
            {show &&
            <TaskStoreProvider taskKey='ADFOX-485' watch>
                {(config, setConfig) => (
                    <div>
                        Config:
                        <br/>
                        <pre>{JSON.stringify(config)}</pre>
                        <br/>
                        <button onClick={() => setConfig({counter: (config.counter || 0) + 1})}>
                            increment counter
                        </button>
                    </div>
                )}
            </TaskStoreProvider>
            }
        </div>
    )
};



