import React, {useState} from 'react';
import { apiCall,  apiSearch, taskUrl} from "../../startrek";
import {Textinput} from "@yandex-lego/components/Textinput/desktop/bundle";
import {Button} from "@yandex-lego/components/Button/desktop/bundle";
import {Modal} from "@yandex-lego/components/Modal/desktop/bundle";
import {Link} from "@yandex-lego/components/Link/desktop/bundle";
import {getPath, getTagsArray, ksort} from "../../lib/functions";
import {TaskLine} from "../TaskLine/TaskLine";
import {HintLink} from "../HintLink/HintLink";
import { Spin } from "@yandex-lego/components/Spin/desktop/bundle";
import '../SprintPlanner/SprintPlanner.css';

import './globals';
import {collapseTextChangeRangesAcrossMultipleVersions} from 'typescript';
import {TasksRef} from '../TasksRef/TasksRef';
import {loadParentsRec} from '../../lib/loadParentsRec';
const $ = window.$;


// const taskCompareFn = (t1, t2) => {
//     if (t1.weight === t2.weight) {
//         return t1.summary < t2.summary ? -1 : 1;
//     }
//     return t1.weight > t2.weight ? -1 : 1;
// }

const getNearestEpic = (task, parents) => {
    const rec = (task, parents) => {
        if (!task.parent) {
            return {summary: task.summary, key: task.key};
        }
        const parent = parents[task.parent.key];
        if (!parent) {
            console.log('отсутствует (возможно нет доступа) parents для таски', task);
            return {summary: task.parent.display, key: task.parent.key};
        }
        if (parent.tags && parent.tags.includes('epic')) {
            return parent;
        }
        return rec(parent, parents);
    };
    if (!task.parent) {
        return null;
    }
    const epicParent = rec(task, parents);
    return epicParent ? epicParent : parents[task.parent.key];
}

const processTasks = (tasks, parents) => {
    console.log('processTasks', tasks, parents);
    const groups = {};
    const people = {};
    const rows = {};
    const statuses = {};
    const taskDict = {};
    const noStoryPoints = [];
    const peopleStat = {};
    const assignees = {};

    for (let task of tasks) {
        let {storyPoints = 0} = task;
        if (task.originalStoryPoints && task.originalStoryPoints > storyPoints) {
            storyPoints = task.originalStoryPoints;
        }
        taskDict[task.key] = task;

        if (!task.storyPoints) {
            noStoryPoints.push(task.key);
        }

        let status = task.status.display;
        if (!statuses[status]) {
            statuses[status] = {count: 0, tasks: []};
        }
        statuses[status].count++;
        statuses[status].tasks.push(task.key);


        let group = 'xxx';
        let groupDesc = {};

        if (!task.parent) {
            group = '.Тип: ' + task.type.display;
            groupDesc = {type: 'type', taskType: task.type};
        } else {
            const epic = getNearestEpic(task, parents);
            group = epic.summary;
            groupDesc = {type: 'parent', parent: epic};
        }
        if (!rows[group]) {
            rows[group] = {
                group,
                cols: {}
            }
        }

        if (!groups[group]) {
            groups[group] = groupDesc;
        }

        task.group = group;

        const reviewers = [...(task.prReviewers || []), ...(task.reviewers || [])];
        const testers = [...(task.qaReviewer || [])];

        const taskPeople = [
            ['assignee', task.assignee],
            ...reviewers.map(emp => ['review', emp]),
            ...testers.map(emp => ['test', emp])
        ];

        assignees[task.assignee.display] = 1;

        const cols = rows[group].cols;
        for (const [taskRole, emp] of taskPeople) {
            let e = emp ? emp.display : 'undefined';
            if (!people[e]) {
                people[e] = emp;
            }
            if (!cols[e]) {
                cols[e] = {};
            }
            if (!cols[e][taskRole]) {
                cols[e][taskRole] = {count: 0, sp: 0, tasks: []};
            }
            cols[e][taskRole].count += 1;
            cols[e][taskRole].sp += storyPoints;
            cols[e][taskRole].tasks.push(task.key);

            if (!peopleStat[taskRole]) {
                peopleStat[taskRole] = {};
            }
            if (!peopleStat[taskRole][e]) {
                peopleStat[taskRole][e] = {count: 0, sp: 0, tasks: []};
            }
            peopleStat[taskRole][e].count++;
            peopleStat[taskRole][e].sp += storyPoints;
            peopleStat[taskRole][e].tasks.push(task.key);
        }
    }



    return {
        statuses,
        noStoryPoints,
        peopleStat,
        rows: ksort(rows),
        people: ksort(people),
        assignees: ksort(assignees),
        groups,
        taskDict
    }
}


export class Analyzer extends React.PureComponent {
    constructor(props) {
        super(props);

        this.state = {
            tasks: null,
            data: processTasks([]),
            loading: false,
            statusMessage: '',
            inputQuery: '',
            inputSprints: '',
            updated: false,
        }
        this.sprintCache = {};
        this.rewriteTimers = {};
    }

    showStatus = (text) => {
        this.setState({statusMessage: text});
        window.setTimeout(() => {
            this.setState({statusMessage: null});
        }, 700)
    }

    setTasks = (tasks, parents = {}) => {
        const data = processTasks(tasks, parents);
        console.log('setTasks data:', data);
        this.setState({
            data: data,
            tasks,
            parents,
            totals: data.totals
        });
    }

    onUpdate = async () => {
        let tasks = [];

        const sprints = getTagsArray(this.state.inputSprints);
        const baseQuery = this.state.inputQuery;
        if (sprints.length === 0 || !baseQuery) {
            alert('Надо заполнить Базовый запрос и спринты');
            return;
        }

        this.setState({loading: true});

        for (const sprint of sprints) {
            let query = `Sprint: ${sprint} AND ${baseQuery}`;
            this.setState({statusMessage: 'Загрузка спринта ' + sprint});
            const tt = await apiSearch(query);
            tasks = [...tasks, ...tt];
        }

        const parentKeys = new Set();
        for (const task of tasks) {
            if (task.parent) {
                parentKeys.add(task.parent.key);
            }
        }
        let parents = {};
        if (parentKeys.size) {
            await loadParentsRec(parentKeys, parents);
        }
        console.log(parents);

        this.setState({loading: false, statusMessage: ''});

        const keysObj = {};
        for (let task of tasks) {
            keysObj[task.key] = true;
        }
        this.setTasks(tasks, parents);

        window.setTimeout(() => {
            $('table').tablesorter();
        }, 100);
        this.setState({updated: true});
    }

    componentDidMount() {
        //this.onUpdate();
    }

    onUseAdfox = () => {
        const people = [
            "Денис Травников",
            "Юрий Тинюков",
            "Александр Тимофеев",
            "Алиса Здоренко",
            "Александр Лашкевич",
            "Михаил Сарайкин",
            "Константин Лопатин",
            "Илья Перфильев",
            "Алексей Шворак",
            "Алексей Глушенок",
            "Вячеслав Тиликов",
            "Дмитрий Глущенко",
            "Альберт Ларин",
            "Альберт Карамышев"
        ];
        const sprints = [
            '2021q4s1',
            '2021q4s2',
            '2021q4s3',
            '2021q4s4',
            '2021q4s5',
            '2021q4s6',
        ];
        const queueCond = 'Queue: !ADFOXUIDUTY AND Queue: !ADFOXUIDUTYTEST';
        const assigneeCond = "Assignee: " + people.map(p => `"${p}"`).join(',');
        const statusCond = 'Status: !Черновик Status: !Открыт AND (Status: !Закрыт OR (Status: Закрыт AND Resolution: "Решен"))';

        this.setState({
            inputQuery: `${queueCond} AND ${assigneeCond} AND ${statusCond}`,
            inputSprints: sprints.join(', '),
        });
    }

    onUsePIBackend = () => {
        const people = [
            "Игорь Свердлов",
            "Илья Аксенов",
            "Станислав Александров",
            "Александр Дядюшенко",
            "Михаил Леонтьев",
            "Мария Полякова",
            "Роман Зуев",
            "Ильдар Ефремов",
            "Михаил Кадакин",
            "Артём Румянцев",
        ];
        const sprints = [
            'ПИ Спринт №7 (2021)',
            'ПИ Спринт №8 (2021)',
            'ПИ Спринт №9 (2021)',
            'ПИ Спринт №10 (2021)',
            'ПИ Спринт №11 (2021)',
            'ПИ Спринт №12 (2021)',
            'ПИ Спринт №13 (2021)',
            'ПИ Спринт №14 (2021)',
            'ПИ Спринт №15 (2021)',
            'ПИ Спринт №16 (2021)',
            'ПИ Спринт №17 (2021)',
            'ПИ Спринт №18 (2021)',
        ];
        const queueCond = 'Queue: PI';
        const assigneeCond = "Assignee: " + people.map(x => `"${x}"`).join(',');
        const statusCond = 'Status: !Черновик Status: !Открыт AND (Status: !Закрыт OR (Status: Закрыт AND Resolution: "Решен"))';

        this.setState({
            inputQuery: `${queueCond} AND ${assigneeCond} AND ${statusCond}`,
            inputSprints: sprints.map(s => `"${s}"`).join(','),
        });
    }

    onUsePIFrontend = () => {
        const people = [
            "Андрей Лунёв",
            "Кристина Григорьева",
            "Василий Миляев",
            "Сергей Митченко",
            "Илья Мищенко",
            "Сергей Павлов",
            "Никита Печенов",
            "Павел Пиляк",
            "Дмитрий Ткач",
            "Сергей Ширшов",
            "Дарья Решетнева",
        ];
        const sprints = [
            'ПИ Спринт №7 (2021)',
            'ПИ Спринт №8 (2021)',
            'ПИ Спринт №9 (2021)',
            'ПИ Спринт №10 (2021)',
            'ПИ Спринт №11 (2021)',
            'ПИ Спринт №12 (2021)',
            'ПИ Спринт №13 (2021)',
            'ПИ Спринт №14 (2021)',
            'ПИ Спринт №15 (2021)',
            'ПИ Спринт №16 (2021)',
            'ПИ Спринт №17 (2021)',
            'ПИ Спринт №18 (2021)',
        ];
        const queueCond = 'Queue: PI';
        const assigneeCond = "Assignee: " + people.map(x => `"${x}"`).join(',');
        const statusCond = 'Status: !Черновик Status: !Открыт AND (Status: !Закрыт OR (Status: Закрыт AND Resolution: "Решен"))';

        this.setState({
            inputQuery: `${queueCond} AND ${assigneeCond} AND ${statusCond}`,
            inputSprints: sprints.map(s => `"${s}"`).join(','),
        });
    }

    render() {
        const {data} = this.state;

        return (
            <div className='sprint-planner'>
                <h1>Анализатор</h1>
                Базовый запрос (без спринтов)
                <Textinput size="s"  view="default"  value={this.state.inputQuery} onChange={(e) => this.setState({inputQuery: e.target.value})} />
                <br/><br/>
                Спринты через запятую
                <Textinput size="s"  view="default"  value={this.state.inputSprints} onChange={(e) => this.setState({inputSprints: e.target.value})} />
                <br/><br/>
                <div>
                Пресеты:
                &nbsp;<HintLink onClick={this.onUseAdfox}>Adfox</HintLink>
                &nbsp;<HintLink onClick={this.onUsePIBackend}>ПИ (бэк)</HintLink>
                &nbsp;<HintLink onClick={this.onUsePIFrontend}>ПИ (фронт)</HintLink>
                </div>
                <br /><br />

                {this.state.updated &&
                    <b>Чтобы изменить запрос - надо перезагрузить страницу</b>
                }

                {!this.state.updated &&
                <div>
                <Button view="action" size="s" onClick={this.onUpdate} disabled={this.state.loading}>
                    Update
                </Button>
                { this.state.loading && (
                    <div id="FetchDataSpinner">
                        <Spin progress view="default" size="m" />
                    </div>
                    )
                }
                </div>
                }
                <div>
                    {this.state.statusMessage}
                </div>

                <br/>
                Statuses:
                <table>
                    <thead>
                    <tr>
                        <th>Статус</th>
                        <th>Кол. задач</th>
                    </tr>
                    </thead>
                    <tbody>
                        {Object.entries(data.statuses).map(([status, {count, tasks}]) =>
                        <tr key={status}>
                            <td>{status}</td>
                            <td>
                                <TasksRef
                                    title={'Статус: ' + status}
                                    tasks={tasks}
                                    taskDict={data.taskDict}
                                >
                                    {count}
                                </TasksRef>
                            </td>
                        </tr>
                        )}
                    </tbody>
                </table>

                По людям:
                <table>
                    <thead>
                    <tr>
                        <th>Кто</th>
                        <th>Исп. (кол.)</th>
                        <th>Исп. (sp)</th>
                        <th>Ревью (кол.)</th>
                        <th>Ревью (sp)</th>
                        <th>Тест (кол.)</th>
                        <th>Тест (sp)</th>
                    </tr>
                    </thead>
                    <tbody>
                    {Object.entries(data.people).map(([e]) =>
                        <tr key={e}>
                            <td><span className='login'>{e}</span></td>
                            <td className='cell-data'>
                                <TasksRef
                                    title={'Исполнитель: ' + e}
                                    tasks={getPath(data.peopleStat, ['assignee', e, 'tasks'], [])}
                                    taskDict={data.taskDict}
                                >
                                    {getPath(data.peopleStat, ['assignee', e, 'count'], '')}
                                </TasksRef>
                            </td>
                            <td className='cell-data'>
                                <TasksRef
                                    title={'Исполнитель: ' + e}
                                    tasks={getPath(data.peopleStat, ['assignee', e, 'tasks'], [])}
                                    taskDict={data.taskDict}
                                >
                                    {getPath(data.peopleStat, ['assignee', e, 'sp'], '')}
                                </TasksRef>
                            </td>
                            <td className='cell-data'>
                                <TasksRef
                                    title={'Ревью: ' + e}
                                    tasks={getPath(data.peopleStat, ['review', e, 'tasks'], [])}
                                    taskDict={data.taskDict}
                                >
                                    {getPath(data.peopleStat, ['review', e, 'count'], '')}
                                </TasksRef>
                            </td>
                            <td className='cell-data'>
                                <TasksRef
                                    title={'Ревью: ' + e}
                                    tasks={getPath(data.peopleStat, ['review', e, 'tasks'], [])}
                                    taskDict={data.taskDict}
                                >
                                    {getPath(data.peopleStat, ['review', e, 'sp'], '')}
                                </TasksRef>
                            </td>
                            <td className='cell-data'>
                                <TasksRef
                                    title={'Тест: ' + e}
                                    tasks={getPath(data.peopleStat, ['test', e, 'tasks'], [])}
                                    taskDict={data.taskDict}
                                >
                                    {getPath(data.peopleStat, ['test', e, 'count'], '')}
                                </TasksRef>
                            </td>
                            <td className='cell-data'>
                                <TasksRef
                                    title={'Тест: ' + e}
                                    tasks={getPath(data.peopleStat, ['test', e, 'tasks'], [])}
                                    taskDict={data.taskDict}
                                >
                                    {getPath(data.peopleStat, ['test', e, 'sp'], '')}
                                </TasksRef>
                            </td>
                        </tr>
                    )}
                    </tbody>
                </table>


                Без оценки:
                <TasksRef
                    title='Без оценки'
                    tasks={data.noStoryPoints}
                    taskDict={data.taskDict}
                >
                    {data.noStoryPoints.length}
                </TasksRef>

                <br/>
                Report:
                <table>
                    <thead>
                    <tr>
                        <th></th>
                        {Object.entries(data.assignees).map(([e]) =>
                            <td key={e}>
                                <span className='login'>{e}</span>
                            </td>
                        )}
                    </tr>
                    </thead>
                    <tbody>
                    {Object.entries(data.rows).map(([group, row]) =>
                        <tr key={group}>
                            <td>
                                {group}&nbsp;
                                {data.groups[group].type === 'parent' &&
                                <Link target='_blank' size="xxs" theme="ghost" href={taskUrl(data.groups[group].parent.key)}>
                                    {data.groups[group].parent.key}
                                </Link>
                                }
                            </td>
                            {Object.entries(data.assignees).map(([e]) =>
                            <td key={e} className='cell-data'>
                                {
                                    (row.cols[e] && row.cols[e].assignee && row.cols[e].assignee.sp &&
                                        <TasksRef
                                            title={
                                                <>
                                                    <span className='login'>{e}</span>
                                                    :&nbsp;
                                                    {group}
                                                </>
                                            }
                                            tasks={row.cols[e].assignee.tasks}
                                            taskDict={data.taskDict}
                                        >
                                            {Math.round(10 * row.cols[e].assignee.sp) / 10}
                                        </TasksRef>
                                    ) || ''
                                }
                            </td>
                            )}
                        </tr>
                    )}
                    </tbody>
                </table>
            </div>
        );
    }
}

