import React, {useRef, useState} from 'react';
import {ComponentStory, ComponentMeta} from '@storybook/react';
import {Button} from '@yandex-lego/components/Button/desktop/bundle';

import {ColorPicker} from './ColorPicker';
import {StickerIcon} from '../Icons/StickerIcon';


export default {
    title: 'ColorPicker',
    component: ColorPicker,
} as ComponentMeta<typeof ColorPicker>;

const iconColorPicker = (className: string) => <StickerIcon className={className} />;

const Template: ComponentStory<typeof ColorPicker> = (args) => {
    const [selectedColor, setSelectedColor] = useState<string | undefined>('#e9efe7');

    return (
        <ColorPicker
            {...args}
            selectedColor={selectedColor}
            onChange={setSelectedColor}
        />
    );
};

const TemplateWithAnchor: ComponentStory<typeof ColorPicker> = (args) => {
    const [selectedColor, setSelectedColor] = useState<string | undefined>('#e9efe7');
    const [isVisible, setIsVisible] = useState(false);

    const ref = useRef<HTMLElement>(null);

    return (
        <div>
            <Button
                innerRef={ref}
                view='raised'
                onClick={() => setIsVisible((prevState) => !prevState)}
                size='s'
                iconLeft={iconColorPicker}
            />
            <ColorPicker
                {...args}
                anchor={ref}
                visible={isVisible}
                selectedColor={selectedColor}
                onChange={setSelectedColor}
            />
        </div>
    );
};

export const Default = Template.bind({});
Default.args = {};

export const WithAnchor = TemplateWithAnchor.bind({});
WithAnchor.args = {};