import React, {RefObject} from 'react';
import {withNaming} from '@bem-react/classname';
import {Tooltip} from '@yandex-lego/components/Tooltip/desktop/bundle';

import './ColorPicker.css';


interface ColorPickerProps {
    onChange(color: string | undefined): void;

    onClose?(): void;

    anchor?: RefObject<HTMLElement>;
    className?: string;
    colorsSet?: Array<string>;
    visible?: boolean;
    selectedColor?: string;
}

const DEFAULT_COLOURS = [
    '#e9efe7',
    '#e7eeef',
    '#efeee7',
    '#efe9e7',
    '#ede7ef',
    undefined,
];

const cn = withNaming({e: '__', m: '_'})('color-picker');

export const ColorPicker: React.VFC<ColorPickerProps> = ({
                                                             selectedColor,
                                                             onChange,
                                                             onClose,
                                                             className,
                                                             anchor,
                                                             colorsSet = DEFAULT_COLOURS,
                                                             visible,
                                                         }) => {

    const changeColorHandler = (color: string | undefined) => () => onChange(color);

    const colorPickerElement = (
        <div className={cn('', {tooltip: Boolean(anchor)}, [className])}>
            <div className={cn('body')}>
                {
                    colorsSet?.map((color, index) => (
                        <div
                            className={cn('color', {selected: color === selectedColor})}
                            onClick={changeColorHandler(color)}
                            key={index}
                            style={{backgroundColor: color}}
                        />
                    ))
                }
            </div>
        </div>
    );

    if (anchor) {
        return (
            <Tooltip
                hasTail
                direction='bottom'
                size='s'
                visible={visible}
                onClose={onClose}
                anchor={anchor}
            >
                {colorPickerElement}
            </Tooltip>
        );
    }

    return colorPickerElement;
};