import React, { useCallback, useEffect, useRef, useState } from "react";
import "./Highlight.css";

const H = ({ content, targetContent = content }) => {
    const [s, setS] = useState(3);
    const timerRef = useRef(null);
    useEffect(() => {
        if (s === 3) {
            setS(2);
        } else {
            setS(0);
            setTimeout(() => setS(1), 10);
            clearTimeout(timerRef.current);
            timerRef.current = setTimeout(() => setS(2), 3000);
        }
    }, [content, targetContent]);
    if (s !== 1) return targetContent;
    return <span className="highlight-anim">{content}</span>;
};

export const Highlight = React.memo(({ children }) => {
    const prevChildrenRef = useRef();
    useEffect(() => {
        prevChildrenRef.current = children;
    });
    const from = prevChildrenRef.current;
    const to = children;
    let content = children;
    let targetContent = children;
    if (typeof from !== "object" && typeof to !== "object") {
        if (from !== to && !isNaN(from) && !isNaN(to)) {
            let diff = Math.round(10 * (+to - from)) / 10;
            if (diff > 0) {
                diff = "+" + diff;
            }
            content = (
                <>
                    {children}
                    <span className="highlight-diff">{diff}</span>
                </>
            );
        }
    }
    return (
        <span>
      <H content={content} targetContent={targetContent} />
    </span>
    );
});
