import React, {HTMLAttributes, KeyboardEventHandler} from 'react';
import {withNaming} from '@bem-react/classname';

import './HintLink.css';

const cn = withNaming({e: '__', m: '_'})('hint-link');

interface HintLinkProps extends HTMLAttributes<HTMLSpanElement> {
    onClick?(): void;

    disabled?: boolean;
}

export const HintLink: React.FC<HintLinkProps> = ({
                                                      onClick,
                                                      className,
                                                      disabled,
                                                      children,
                                                      ...props
                                                  }) => {

    const spaceButtonClickHandler: KeyboardEventHandler<HTMLSpanElement> = (e) => {
        e.code === 'Space' && clickHandler();
    };

    const clickHandler = () => {
        if (!disabled && onClick) {
            onClick();
        }
    };

    return (
        <span
            className={cn('', {disabled}, [className])}
            tabIndex={0}
            onClick={clickHandler}
            onKeyPress={spaceButtonClickHandler}
            {...props}
        >
            {children}
        </span>
    );
};
