import React from 'react';
import {withNaming} from '@bem-react/classname';

import './Icon.css';


const cn = withNaming({e: '__', m: '_'})('icon');

export const ConfirmIcon: React.VFC<{className?: string}> = ({className}) => (
    <span className={cn({type: 'confirm'}, [className])}>
        <svg
            width='16'
            height='16'
            xmlns='http://www.w3.org/2000/svg'
        >
            <svg xmlns='http://www.w3.org/2000/svg' width='17' height='16'>
                <path
                    fillRule='evenodd'
                    d='M6.967 10.354L3.389 6.658 2.103 7.787l4.841 5.002 8.462-8.428-1.264-1.151z'
                />
            </svg>
        </svg>
    </span>
);