import React from 'react';
import {withNaming} from '@bem-react/classname';

import './Icon.css';


const cn = withNaming({e: '__', m: '_'})('icon');

export const DownloadIcon: React.VFC<{className?: string}> = ({className}) => (
    <span className={cn({type: 'edit'}, [className])}>
        <svg
            width='16'
            height='16'
            xmlns='http://www.w3.org/2000/svg'
        >
            <path
                fillRule='evenodd'
                clipRule='evenodd'
                d='M8 .003a1 1 0 00-1 1v6.79c0 .472.034.945.1 1.413l.138.96-.047.045-.464-.742a10 10 0 00-1.405-1.764l-.412-.413a1 1 0 00-1.413 1.414l3.8 3.8a1 1 0 001.414-.001l3.793-3.8a1 1 0 00-1.414-1.412l-.407.407A9.999 9.999 0 009.28 9.459l-.472.753-.046-.047.136-.959c.067-.468.101-.94.101-1.414v-6.79a1 1 0 00-1-1zm-6 15a1 1 0 011-1h10a1 1 0 010 2H3a1 1 0 01-1-1z'
            />
        </svg>
    </span>
);
