import React from 'react';
import {withNaming} from '@bem-react/classname';

import './Icon.css';


const cn = withNaming({e: '__', m: '_'})('icon');

export const EditIcon: React.VFC<{className?: string}> = ({className}) => (
    <span className={cn({type: 'edit'}, [className])}>
        <svg
            width='16'
            height='16'
            xmlns='http://www.w3.org/2000/svg'
        >
            <path
                d='M14.47 4.36a6.75 6.75 0 00-1.202-1.628 6.748 6.748 0 00-1.625-1.2l-.002-.002.92-.92c.495-.494 1.308-.812 2.475.354 1.166 1.167.848 1.98.353 2.475l-.92.92zm-1.128 1.126L4.73 14.099a2.5 2.5 0 01-.861.562l-2.552.993a.75.75 0 01-.971-.97l.993-2.553a2.5 2.5 0 01.562-.86l8.613-8.614a5.235 5.235 0 011.693 1.136c.5.5.88 1.077 1.135 1.693z'
            />
        </svg>
    </span>
);