import React from 'react';
import {withNaming} from '@bem-react/classname';

import './Icon.css';


const cn = withNaming({e: '__', m: '_'})('icon');

export const StickerIcon: React.VFC<{className?: string}> = ({className}) => (
    <span className={cn({type: 'sticker'}, [className])}>
        <svg
            width='24'
            height='24'
            xmlns='http://www.w3.org/2000/svg'
        >
            <path
                fillRule='evenodd'
                clipRule='evenodd'
                d='M10.472 2.116C5.675 2.851 2 6.996 2 12c0 5.523 4.477 10 10 10 5.003 0 9.148-3.675 9.884-8.472A9 9 0 0110.472 2.116zm11.39 9.274c-.287-.853-1.173-2.611-3.906-5.346-2.734-2.734-4.493-3.62-5.346-3.906a7 7 0 009.253 9.253z'
            />
        </svg>
    </span>
);