import React from 'react';
import {withNaming} from '@bem-react/classname';

import './Icon.css';


const cn = withNaming({e: '__', m: '_'})('icon');

export const SyncIcon: React.VFC<{className?: string}> = ({className}) => (
    <span className={cn({type: 'sync'}, [className])}>
        <svg
            xmlns='http://www.w3.org/2000/svg'
            width='16'
            height='16'
        >
            <path
                fillRule='evenodd'
                d='M11.426.06c-.963.136-1.704.95-1.55 2.038.156 1.088 1.148 2.038 2.112 1.901.963-.137 1.531-1.15 1.376-2.239C13.21.672 12.39-.078 11.426.06zM6.04 8.62L3.757 7.437a1.1 1.1 0 01-.5-1.473l1.66-3.377a1.1 1.1 0 011.477-.496L10.1 3.886c.787.417 1.118 1.088 1.437 1.734.263.534.518 1.05 1.015 1.395.609.421.96.343 1.37.25.15-.033.309-.068.49-.081.42-.03.846.087.846.507 0 .42-.17.677-.677.846-.886.295-2.223.338-3.128-.508-.906-.845-1.1-1.014-1.607-.676-.776.518.254 2.198.254 2.198s.845 1.269 1.1 2.537c.027.142.055.277.082.408.188.913.332 1.611.277 2.72-.02.42-.34.762-.76.762a.761.761 0 01-.762-.761c0-.42-.206-1.62-.444-2.706-.24-1.087-1.353-2.205-2.114-1.945-.347.118-.666.41-1.148.852-.138.127-.29.266-.459.416-.761.677-1.785 1.269-3.467 1.269-.42 0-.907-.057-1.047-.453a.761.761 0 01.462-.972c.101-.036.277-.053.497-.075.642-.064 1.657-.166 2.287-.868A9.245 9.245 0 006.04 8.621zM4.837 5.95a.338.338 0 00.151.454l1.425.713a.34.34 0 00.454-.15L7.9 4.907a.346.346 0 00-.157-.461c-.277-.14-.56-.293-.842-.444-.189-.102-.377-.204-.562-.3a.333.333 0 00-.453.148l-1.05 2.1z'
                clipRule='evenodd'
            />
        </svg>
    </span>
);