import React from 'react';
import {withNaming} from '@bem-react/classname';

import './Icon.css';


const cn = withNaming({e: '__', m: '_'})('icon');

export const TrashIcon: React.VFC<{className?: string}> = ({className}) => (
    <span className={cn({type: 'trash'}, [className])}>
        <svg
            width='16'
            height='16'
            xmlns='http://www.w3.org/2000/svg'
        >
            <path
                fillRule='evenodd'
                clipRule='evenodd'
                d='M4 3.003a3 3 0 013-3h2a3 3 0 013 3h2a1 1 0 110 2h-.654l-.74 9.615a1.5 1.5 0 01-1.495 1.385H4.889a1.5 1.5 0 01-1.496-1.385l-.74-9.615H2a1 1 0 010-2h2zm7.34 2H4.66l.692 9h5.296l.692-9zm-4.34-3a1 1 0 00-1 1h4a1 1 0 00-1-1H7z'
            />
        </svg>
    </span>
);