import * as React from 'react';

let closeTimer: number | null = null;
let closeLocked = false;

export type PanelProps = {
    className: string,
    onClose: () => void
};

export class Panel extends React.PureComponent<PanelProps> {
    private containerRef: React.RefObject<HTMLDivElement> = React.createRef();

    onWindowClick = () => {
        if (!closeLocked) {
            this.close();
        }
    }

    onPanelClick = (e: React.MouseEvent<HTMLElement>) => {
        e.stopPropagation();
    }

    onWindowKeyDown = (e: KeyboardEvent) => {
        if (e.key === 'Escape') {
            this.close();
        }
    }

    protected close = () => {
        this.props.onClose();
    }

    componentDidUpdate() {
        closeLocked = true;
        setTimeout(() => {
            closeLocked = false;
        }, 50);

        if (closeTimer) {
            window.clearTimeout(closeTimer);
            closeTimer = null;
        }
    }

    componentDidMount() {
        setTimeout(() => {
            console.log('install listeners');
            window.addEventListener('click', this.onWindowClick);
            window.addEventListener('keydown', this.onWindowKeyDown);
        }, 0);
    }

    componentWillUnmount() {
        console.log('uninstall listeners');
        window.removeEventListener('click', this.onWindowClick);
        window.removeEventListener('keydown', this.onWindowKeyDown)
    }

    render() {
        return (
            <div
                className={this.props.className}
                onClick={this.onPanelClick}
                ref={this.containerRef}
            >
                {this.props.children}
            </div>
        )
    }
}
