import {BoardSuggest, QuarterBlock, QuarterTableSprintInfo} from './QuarterConfigurator.types';

type ActionCreatorWithPayload<T extends QUARTER_CONFIGURATOR_ACTION, P> = (payload: P) => {type: T; payload: P};
type ActionCreator<T extends QUARTER_CONFIGURATOR_ACTION> = () => {type: T};

export enum QUARTER_CONFIGURATOR_ACTION {
    SET_CONFIG = 'SET_CONFIG',
    SET_NAME = 'SET_NAME',
    SET_FILTER = 'SET_FILTER',
    SET_BOARD = 'SET_BOARD',
    UPDATE_SPRINT = 'UPDATE_SPRINT',
    ADD_SPRINT = 'ADD_SPRINT',
    UPDATE_BLOCK_INFO = 'UPDATE_BLOCK_INFO',
    ADD_BLOCK = 'ADD_BLOCK',
    DELETE_BLOCK = 'DELETE_BLOCK',
    SET_SHOULD_NOT_UPDATE = 'SET_SHOULD_NOT_UPDATE',
    SET_SHOULD_NOT_SAVE = 'SET_SHOULD_NOT_SAVE',
    DELETE_SPRINT = 'DELETE_SPRINT',
}


export const setNameAction: ActionCreatorWithPayload<QUARTER_CONFIGURATOR_ACTION.SET_NAME, string> = (quarterName) => {
    return {
        type: QUARTER_CONFIGURATOR_ACTION.SET_NAME,
        payload: quarterName,
    };
};

export const setFilterAction: ActionCreatorWithPayload<QUARTER_CONFIGURATOR_ACTION.SET_FILTER, string> = (filter) => {
    return {
        type: QUARTER_CONFIGURATOR_ACTION.SET_FILTER,
        payload: filter,
    };
};

export const setBoardAction: ActionCreatorWithPayload<QUARTER_CONFIGURATOR_ACTION.SET_BOARD, BoardSuggest> = (board) => {
    return {
        type: QUARTER_CONFIGURATOR_ACTION.SET_BOARD,
        payload: board,
    };
}

export const addBlockAction: ActionCreator<QUARTER_CONFIGURATOR_ACTION.ADD_BLOCK> = () => {
    return {
        type: QUARTER_CONFIGURATOR_ACTION.ADD_BLOCK,
    }
}

export const addSprintAction: ActionCreator<QUARTER_CONFIGURATOR_ACTION.ADD_SPRINT> = () => {
    return {
        type: QUARTER_CONFIGURATOR_ACTION.ADD_SPRINT,
    }
}

type UpdateBlockInfoPayload = {
    index: number;
    shouldUpdateInfo: boolean;
    update: Partial<QuarterBlock>;
}
export const updateBlockInfoAction: ActionCreatorWithPayload<QUARTER_CONFIGURATOR_ACTION.UPDATE_BLOCK_INFO, UpdateBlockInfoPayload> = (payload) => {
    return {
        type: QUARTER_CONFIGURATOR_ACTION.UPDATE_BLOCK_INFO,
        payload,
    };
}
type UpdateSprintInfoPayload = {
    index: number;
    update: Partial<QuarterTableSprintInfo>;
}
export const updateSprintInfoAction: ActionCreatorWithPayload<QUARTER_CONFIGURATOR_ACTION.UPDATE_SPRINT, UpdateSprintInfoPayload> = (payload) => {
    return {
        type: QUARTER_CONFIGURATOR_ACTION.UPDATE_SPRINT,
        payload,
    }
}

export const deleteBlockAction: ActionCreatorWithPayload<QUARTER_CONFIGURATOR_ACTION.DELETE_BLOCK, number> = (blockIndex) => {
    return {
        type: QUARTER_CONFIGURATOR_ACTION.DELETE_BLOCK,
        payload: blockIndex,
    }
}

export const deleteSprintAction: ActionCreatorWithPayload<QUARTER_CONFIGURATOR_ACTION.DELETE_SPRINT, number> = (sprintIndex) => {
    return {
        type: QUARTER_CONFIGURATOR_ACTION.DELETE_SPRINT,
        payload: sprintIndex,
    }
}

export const setShouldNotSaveAction: ActionCreator<QUARTER_CONFIGURATOR_ACTION.SET_SHOULD_NOT_SAVE> = () => {
    return {
        type: QUARTER_CONFIGURATOR_ACTION.SET_SHOULD_NOT_SAVE,
    }
}

export const setShouldNotUpdateAction: ActionCreator<QUARTER_CONFIGURATOR_ACTION.SET_SHOULD_NOT_UPDATE> = () => {
    return {
        type: QUARTER_CONFIGURATOR_ACTION.SET_SHOULD_NOT_UPDATE,
    }
}

export const setConfigAction: ActionCreatorWithPayload<QUARTER_CONFIGURATOR_ACTION.SET_CONFIG, any> = (newConfig) => {
    return {
        type: QUARTER_CONFIGURATOR_ACTION.SET_CONFIG,
        payload: newConfig,
    }
}

export type QuarterConfiguratorAction =
    ReturnType<typeof setNameAction> |
    ReturnType<typeof setFilterAction> |
    ReturnType<typeof setBoardAction> |
    ReturnType<typeof addBlockAction> |
    ReturnType<typeof addSprintAction> |
    ReturnType<typeof updateBlockInfoAction> |
    ReturnType<typeof updateSprintInfoAction> |
    ReturnType<typeof setConfigAction> |
    ReturnType<typeof setShouldNotUpdateAction> |
    ReturnType<typeof setShouldNotSaveAction> |
    ReturnType<typeof deleteBlockAction> |
    ReturnType<typeof deleteSprintAction>;
