import {QuarterTableRowProps} from '../QuarterTable/QuarterTableRow/QuarterTableRow';

/**
 * Префикс структуры таблицы квартала
 */
export const prefixParamsStructure: QuarterTableRowProps['structure'] = [
    {
        backgroundColor: 'rgb(198, 215, 221)',
        type: 'extra-wide',
    },
    {
        type: 'default',
        purpose: 'space',
    },
    {
        type: 'wide',
        purpose: 'space',
    },
    {
        type: 'default',
        purpose: 'space',
    },
];

/**
 * Суффикс структуры таблицы квартала
 */
export const suffixStructure: QuarterTableRowProps['structure'] = [
    {
        type: 'wide',
        purpose: 'data',
    },
    {
        backgroundColor: '#c6d7dd',
        type: 'wide',
        purpose: 'data',
    },
];

/**
 * Конфиг применяемый по умолчанию,
 * если в задаче отсутствует комментарий с конфигурацией
 */
export const defaultQuarterConfig = {
    quarterName: 'Default Quarter Name',
    blocks: [
        {
            name: 'Default Block Name',
            coefficient: 1,
            products: [],
        },
    ],
    sprints: [],
    issuesMap: {},
};