import {StartrekProperty} from '../Tree/modules/types';

export interface Sprint {
    archived: boolean;
    board: {
        display: string;
        id: string;
        self: string;
    }
    createdAt: string;
    createdBy: StartrekProperty;
    endDate: string;
    endDateTime: string;
    id: number;
    name: string;
    self: string;
    startDate: string;
    startDateTime: string;
    status: string;
    version: number;
}

export interface Issue {
    assignee?: StartrekProperty;
    boards: Array<{
        id: number;
        name: string;
    }>
    commentWithExternalMessageCount: number;
    commentWithoutExternalMessageCount: number;
    createdAt: string;
    createdBy: StartrekProperty;
    description: string;
    favorite: boolean;
    followers?: Array<StartrekProperty>;
    id: string;
    key: string;
    lastCommentUpdatedAt?: string;
    parent: StartrekProperty;
    pendingReplyFrom: Array<StartrekProperty>;
    prReviewers: Array<StartrekProperty>;
    previousStatus?: StartrekProperty;
    previousStatusLastAssignee?: StartrekProperty;
    priority?: StartrekProperty;
    queue: StartrekProperty;
    self: string;
    sprint?: Array<StartrekProperty>;
    status: StartrekProperty;
    statusStartTime: string;
    storyPoints: number;
    summary: string;
    originalStoryPoints: number;
    tags: Array<string>;
    updatedAt: string;
    updatedBy: StartrekProperty;
    version: number;
    votes: number;
    weight: number;
}

export type ExtendedIssue = Issue & {
    children?: Array<string>
    computedStoryPoints: number;
};

export interface ProductSprintConfig {
    capacity: number;
    issues?: Array<string>;
}

export interface QuarterSprint extends Partial<Sprint> {
    description: string;
    totalCapacity: number;
}

export interface QuarterBlockProduct {
    budget: number;
    name: string;
    sprints: Record<string, ProductSprintConfig>;

    color?: string;
    issueKey?: string;
    weight?: number;
}

export interface QuarterBlock {
    name: string;
    coefficient: number;
    products: Array<QuarterBlockProduct>;

    color?: string;
}

export interface BoardSuggest {
    display: string;
    id: string;
    self: string;
}

export interface QuarterTableSprintInfo {
    description: string;
    endDate?: string;
    name?: string;
    id?: number;
    totalCapacity?: number;
}
