import React from 'react';
import {ComponentStory, ComponentMeta} from '@storybook/react';

import {QuarterTable, QuarterTableProps} from './QuarterTable';
import {QuarterTableRowProps} from './QuarterTableRow/QuarterTableRow';
import {QuarterTableCellColorPicker} from './QuarterTableCellColorPicker/QuarterTableCellColorPicker';


export default {
    title: 'QuarterTable',
    component: QuarterTable,
} as ComponentMeta<typeof QuarterTable>;

const Template: ComponentStory<typeof QuarterTable> = (args) => <QuarterTable {...args} />;

const structure: QuarterTableRowProps['structure'] = [
    {
        backgroundColor: '#56a16b',
        cells: [
            {
                type: 'extra-wide',
            },
        ],
    },
    {
        type: 'wide',
        purpose: 'space',
    },
    {
        type: 'wide',
    },
    {
        type: 'wide',
    },
    {
        type: 'wide',
        purpose: 'space',
    },
    {
        backgroundColor: '#56a16b',
        cells: [
            {
                type: 'default',
            },
            {
                type: 'default',
            },
            {
                type: 'default',
            },
            {
                type: 'default',
            },
            {
                type: 'default',
            },
            {
                type: 'default',
            },
            {
                type: 'default',
            },
        ],
    },
];

const data: QuarterTableProps['data'] = [
    [
        'Название продукта',
        'Бюджет',
        'Факт',
        'q3s1',
        'q3s2',
        'q3s3',
        'q3s4',
        'q3s5',
        'q3s6',
        'q3s7',
    ],
    [
        'Крутой продукт',
        '22sp',
        '12sp',
        '1sp',
        '2sp',
        '2sp',
        '1sp',
        '4sp',
        '1sp',
        '1sp',
    ],
    [
        'Крутой продукт',
        '22sp',
        '12sp',
        '1sp',
        '2sp',
        '2sp',
        '1sp',
        '4sp',
        '1sp',
        '1sp',
    ],
    [
        'Крутой продукт',
        '22sp',
        '12sp',
        '1sp',
        '2sp',
        '2sp',
        '1sp',
        '4sp',
        '1sp',
        '1sp',
    ],
    [
        'Крутой продукт',
        '22sp',
        '12sp',
        '1sp',
        '2sp',
        '2sp',
        '1sp',
        '4sp',
        '1sp',
        '1sp',
    ],
    [
        'Выбор цвета',
        <QuarterTableCellColorPicker onChange={() => {}} selectedColor={'#efeee7'}/>
    ],

]

export const Default = Template.bind({});
Default.args = {
    structure,
    data,
}