import React from 'react';
import {withNaming} from '@bem-react/classname';

import {QuarterTableRow, QuarterTableRowProps, QuarterTableRowStructure} from './QuarterTableRow/QuarterTableRow';

import './QuarterTable.css';


type DataElement = QuarterTableRowProps['data'] |
    {
        values: QuarterTableRowProps['data'],
        backgroundColor?: string,
        backgroundCellColor?: string
    };

export interface QuarterTableProps {
    data: Array<DataElement>;
    structure: QuarterTableRowStructure;
    backgroundCellColor?: string;
    backgroundColor?: string;
    className?: string;
    noHeader?: boolean;
}

const cn = withNaming({e: '__', m: '_'})('quarter-table');

const checkIsDataExtended = (dataArray: DataElement): dataArray is QuarterTableRowProps['data'] => {
    return Array.isArray(dataArray);
};

export const QuarterTable: React.VFC<QuarterTableProps> = ({
                                                               data,
                                                               className,
                                                               structure,
                                                               backgroundColor,
                                                               noHeader,
                                                           }) => {
    const checkIsHeaderRow = (index: number) => {
        return !index && !noHeader;
    };

    return (
        <div className={cn('', [className])}>
            {
                data.map(
                    (rowData, index) =>
                        checkIsDataExtended(rowData) ?
                            <QuarterTableRow
                                backgroundColor={backgroundColor}
                                key={index}
                                type={checkIsHeaderRow(index) ? 'header' : 'default'}
                                structure={structure}
                                data={rowData}
                            /> :
                            <QuarterTableRow
                                backgroundCellColor={rowData.backgroundCellColor}
                                backgroundColor={rowData.backgroundColor || backgroundColor}
                                key={index}
                                type={checkIsHeaderRow(index) ? 'header' : 'default'}
                                structure={structure}
                                data={rowData.values}
                            />,
                )
            }
        </div>
    );
};

