import React from 'react';
import { ComponentStory, ComponentMeta } from '@storybook/react';

import {QuarterTableCell} from './QuarterTableCell';

export default {
    title: 'QuarterTableCell',
    component: QuarterTableCell,
    args: {
        backgroundColor: '#dce3d9',
    }
} as ComponentMeta<typeof QuarterTableCell>;

const Template: ComponentStory<typeof QuarterTableCell> = (args) => <QuarterTableCell {...args} />;

export const Default = Template.bind({});
Default.args = {
    type: 'default',
    data: '2sp',
};

export const Wide = Template.bind({});
Wide.args = {
    type: 'wide',
    data: 'Бюджет',
};

export const ExtraWide = Template.bind({});
ExtraWide.args = {
    type: 'extra-wide',
    data: 'Единый транспорт',
};