import React from 'react';
import {withNaming} from '@bem-react/classname';

import './QuarterTableCell.css';


export type QuarterTableCellType = 'wide' | 'default' | 'extra-wide' | 'fill';

export interface QuarterTableCellProps {
    /**
     * цвет фона ячейки
     */
    backgroundColor?: string;
    className?: string;
    /**
     * Тип ячейки влияет на ширину ячейки: 'wide' | 'default' | 'extra-wide' | 'fill'
     */
    type?: QuarterTableCellType;
    /**
     * Содержимое ячейки
     */
    data?: string | number | React.ReactElement;
}

const cn = withNaming({e: '__', m: '_'})('quarter-table-cell');

export const QuarterTableCell = React.memo<QuarterTableCellProps>(({
                                                                       backgroundColor,
                                                                       type = 'default',
                                                                       data,
                                                                       className,
                                                                   }) => {
    return (
        <div
            className={cn({type, 'content-type': typeof data}, [className])}
            style={{backgroundColor}}
        >
            {data}
        </div>
    );
});

QuarterTableCell.displayName = 'QuarterTableCell';