import React, {useRef, useState} from 'react';
import {withNaming} from '@bem-react/classname';

import {ColorPicker} from '../../ColorPicker/ColorPicker';

import './QuarterTableCellColorPicker.css';


const cn = withNaming({e: '__', m: '_'})('quarter-table-cell-color-picker');

interface QuarterTableCellColorPickerProps {
    onChange(color: string): void;

    selectedColor?: string;
    className?: string;
    colorsSet?: Array<string>;
}

export const QuarterTableCellColorPicker: React.VFC<QuarterTableCellColorPickerProps> = ({
                                                                                             onChange,
                                                                                             selectedColor,
                                                                                             className,
                                                                                             colorsSet,
                                                                                         }) => {
    const ref = useRef<HTMLDivElement>(null);
    const [isVisible, setIsVisible] = useState(false);

    const selectColorClickHandler = () => setIsVisible((prevState) => !prevState);
    const closeHandler = () => setIsVisible(false);

    return (
        <div className={cn('', [className])}>
            <div
                style={{backgroundColor: selectedColor}}
                ref={ref}
                onClick={selectColorClickHandler}
                className={cn('select')}
            />
            <ColorPicker
                anchor={ref}
                colorsSet={colorsSet}
                onChange={onChange}
                onClose={closeHandler}
                visible={isVisible}
                selectedColor={selectedColor}
            />
        </div>
    );
};