import React, {useState} from 'react';
import {withNaming} from '@bem-react/classname';

import {ResponsiveInput} from '../../ResponsiveInput/ResponsiveInput';

import './QuarterTableCellEditableText.css';


interface QuarterTableCellEditableTextProps {
    className?: string;
    disabled?: boolean;

    onChange?(value: string): void;

    value?: string | number;
    suffix?: string;
}

const cn = withNaming({e: '__', m: '_'})('quarter-table-cell-editable-text');

export const QuarterTableCellEditableText: React.FC<QuarterTableCellEditableTextProps> = ({
                                                                                              onChange,
                                                                                              value,
                                                                                              className,
                                                                                              suffix,
                                                                                              disabled,
                                                                                              children,
                                                                                          }) => {
    const [isEditMode, setIsEditMode] = useState(false);

    const closeHandler = () => {
        setIsEditMode(false);
    };

    const cellClickHandler = () => setIsEditMode(!disabled);

    const changeHandler = (value: string) => {
        onChange && onChange(value);
        closeHandler();
    };

    return (
        <div
            onClick={cellClickHandler}
            className={cn('', {disabled}, [className])}
        >
            {
                isEditMode ?
                    <ResponsiveInput
                        autoFocus
                        className={cn('input')}
                        type={'text'}
                        value={value}
                        disabled={disabled}
                        view="default"
                        onSave={changeHandler}
                        onCancel={closeHandler}
                    /> :
                    <div className={cn('displayed-value')}>
                        {value}
                        <span className={cn('suffix')}>
                            {suffix}
                        </span>
                    </div>
            }
            <div className={cn('body')}>
                {children}
            </div>
        </div>
    );
};
