import React from 'react';
import {withNaming} from '@bem-react/classname';

import {QuarterTableCellEditableText} from '../QuarterTableCellEditableText/QuarterTableCellEditableText';
import {TasksRef} from '../../TasksRef/TasksRef';

import './QuarterTableCellProductCapacity.css';


interface QuarterTableCellProductCapacityProps {
    expired: boolean;
    value: string | number;
    issuesMap: Record<string, any>;
    issuesKeys: Array<string>;

    onChange?(value: string): void;

    className?: string;
    suffix?: string;
}

const cn = withNaming({e: '__', m: '_'})('quarter-table-cell-product-capacity');

export const QuarterTableCellProductCapacity: React.VFC<QuarterTableCellProductCapacityProps> = ({
                                                                                                     expired,
                                                                                                     value,
                                                                                                     className,
                                                                                                     suffix,
                                                                                                     onChange,
                                                                                                     issuesKeys,
                                                                                                     issuesMap,
                                                                                                 }) => {
    if (!expired) {
        return (
            <QuarterTableCellEditableText
                onChange={onChange}
                className={cn('', [className])}
                suffix={suffix}
                value={value}
            />
        );
    }

    return (
        <div className={cn('', {expired: true}, [className])}>
            <TasksRef
                title={'Соответствующие ячейке задачи'}
                tasks={issuesKeys}
                groupByParent={true}
                taskDict={issuesMap}
                hintLinkClassName={cn('hint-link')}
            >
                {value}
                <span className={cn('suffix')}>
                    {suffix}
                </span>
            </TasksRef>
        </div>
    );
};
