import React from 'react';
import {ComponentStory, ComponentMeta} from '@storybook/react';

import {QuarterTableRow, QuarterTableRowProps} from './QuarterTableRow';
import {QuarterTableCellSprint} from '../QuarterTableCellSprintSelect/QuarterTableCellSprintSelect';


export default {
    title: 'QuarterTableRow',
    component: QuarterTableRow,
} as ComponentMeta<typeof QuarterTableRow>;

const structure: QuarterTableRowProps['structure'] = [
    {
        backgroundColor: '#56a16b',
        cells: [
            {
                type: 'extra-wide',
            },
        ],
    },
    {
        type: 'wide',
        purpose: 'space',
    },
    {
        type: 'wide',
    },
    {
        type: 'wide',
    },
    {
        type: 'wide',
        purpose: 'space',
    },
    {
        backgroundColor: '#56a16b',
        cells: [
            {
                type: 'default',
            },
            {
                type: 'default',
            },
            {
                type: 'default',
            },
            {
                type: 'default',
            },
            {
                type: 'default',
            },
            {
                type: 'default',
            },
            {
                type: 'default',
            },
        ],
    },
];

const data: QuarterTableRowProps['data'] = [
    'Название продукта',
    'Бюджет',
    'Факт',
    <QuarterTableCellSprint
        onSprintDelete={() => {}}
        onSprintInfoChange={() => {}}
        sprintInfo={{description: 'q3s2', id: 1}}
    />,
    'q3s2',
    'q3s3',
    'q3s4',
    'q3s5',
    'q3s6',
    'q3s7',
];

const Template: ComponentStory<typeof QuarterTableRow> = (args) => <QuarterTableRow {...args} />;

export const Default = Template.bind({});
Default.args = {
    structure,
    data,
    backgroundCellColor: '#dce3d9',
};