import React, {useEffect} from 'react';

export function useClickOutside(ref: React.RefObject<HTMLElement>, handleClickOutside: () => void) {
    useEffect(() => {
        function clickOutsideHandler(event: MouseEvent) {
            if (ref.current && !ref.current.contains(event.target as HTMLElement)) {
                handleClickOutside();
            }
        }

        document.addEventListener("mousedown", clickOutsideHandler);
        return () => {
            document.removeEventListener("mousedown", clickOutsideHandler);
        };
    }, [ref, handleClickOutside]);
}